# setup.py
from setuptools import setup, Extension, find_packages
from setuptools.command.build_ext import build_ext
import os
import sys
import shutil

rpath_link_args = []
if sys.platform.startswith('linux'):
    rpath_link_args = ['-Wl,-rpath,$ORIGIN']

py_xlt_api_ext = Extension(
    name='py_xlt_api._py_xlt_api',
    sources=[
        'py_xlt_api_swig.i',
    ],

    language='c++',
    extra_compile_args=['-std=c++11'],
    swig_opts=['-threads', '-c++', '-Iinclude'],
    include_dirs=['include', 'include/xlt_api', 'include/xlt_base'],
    library_dirs=['lib'],
    libraries=['xlt_api'],
    extra_link_args=rpath_link_args,
)

class CustomBuildExt(build_ext):
    def run(self):
        super().run()
        ext_dir = self.get_ext_fullpath('py_xlt_api._py_xlt_api')
        pkg_dir = os.path.dirname(ext_dir)
        shutil.copy('lib/libxlt_api.so', pkg_dir)
        shutil.copy('py_xlt_api.py', pkg_dir)

setup(
    name='py_xlt_api',
    version="v1.5.1.2",
    packages=find_packages(),
    include_package_data=True,

    ext_modules=[py_xlt_api_ext],
    cmdclass={'build_ext': CustomBuildExt},

    package_data={
        'py_xlt_api': [
            'py_xlt_api.py',
            'libxlt_api.so',
        ]
    },
)
