/* File : py_xlt_api_swig.i */
%module(directors="1") py_xlt_api

%{
#include "xlt_api/xlt_api.h"
#include "xlt_api/sze_hpf_define.h"
#include "xlt_api/sse_hpf_define.h"
%}

%include "stdint.i"
%include "std_vector.i"  // 包含对 std::vector 的支持
%include "std_string.i"  // 包含对 std::string 的支持

namespace std {
    %template(VectorString) vector<string>;
}

%include "typemaps.i"

%typemap(in) (char (*)[x1::CONST_STR_SECURITY_CODE_LEN]) {
    int i;
    if (!PyList_Check($input)) {
        PyErr_SetString(PyExc_ValueError, "Expecting a list");
        SWIG_fail;
    }
    int size = PyList_Size($input);
    $1 = (char (*)[x1::CONST_STR_SECURITY_CODE_LEN]) malloc(size*sizeof(char [x1::CONST_STR_SECURITY_CODE_LEN]));
    for (i = 0; i < size; i++) {
        PyObject* item = PyList_GetItem($input, i);
        if (PyUnicode_Check(item)) {
            Py_ssize_t len;
            const char* temp_str = PyUnicode_AsUTF8AndSize(item, &len);
            if (len < x1::CONST_STR_SECURITY_CODE_LEN) {
                strncpy($1[i], temp_str, len);
                $1[i][len] = '\0';
            } else {
                strncpy($1[i], temp_str, x1::CONST_STR_SECURITY_CODE_LEN-1);
                $1[i][x1::CONST_STR_SECURITY_CODE_LEN-1] = '\0';
            }
        }
    }
}

%typemap(out) char[x1::CONST_STR_SECURITY_CODE_LEN] {
$result = PyUnicode_FromStringAndSize($1, strnlen($1, 9));
}

%typemap(out) char report_id[ANY] {
    $result = PyBytes_FromStringAndSize($1, 32);
}

%typemap(directorin)char report_id[ANY] {
    $input  = PyBytes_FromStringAndSize($1, 32);
}

// 使用 thread_local 变量在两个 typemap 之间传递 report_size
%{
#include <cstdint>
static thread_local uint32_t g_current_raw_report_size = 0;
%}

// 先处理 report_size，保存其值并传递给 Python
%typemap(directorin) uint32_t report_size {
    g_current_raw_report_size = $1;
    $input = PyLong_FromUnsignedLong($1);
}

// 再处理 raw_report，使用保存的 report_size
%typemap(directorin) char* raw_report {
    if ($1 != NULL && g_current_raw_report_size > 0) {
        $input = PyBytes_FromStringAndSize((const char*)$1, g_current_raw_report_size);
    } else {
        Py_INCREF(Py_None);
        $input = Py_None;
    }
}

// =====================================================
// ============== 盛立行情结构体处理 ======================
// =====================================================
%include "sze_hpf_define.h"
%include "sse_hpf_define.h"

// 处理m_symbol字符数组到Python字符串的转换
%typemap(in) unsigned char m_symbol[SZE_SYMBOL_LEN] {
    if (PyString_Check($input)) {
        char *temp = PyString_AsString($input);
        strncpy((char*)$1, temp, SZE_SYMBOL_LEN);
        $1[SZE_SYMBOL_LEN-1] = '\0'; // 确保以null结尾
    } else {
        SWIG_exception(SWIG_TypeError, "string expected");
    }
}

%typemap(out) unsigned char m_symbol[SZE_SYMBOL_LEN] {
    $result = PyString_FromString((const char*)$1);
}

%typemap(memberin) unsigned char m_symbol[SZE_SYMBOL_LEN] {
    strncpy((char*)$1, (const char*)$input, SZE_SYMBOL_LEN);
    $1[SZE_SYMBOL_LEN-1] = '\0';
}

// 处理m_symbol字符数组到Python字符串的转换
%typemap(in) unsigned char m_symbol[SSE_SYMBOL_LEN] {
    if (PyString_Check($input)) {
        char *temp = PyString_AsString($input);
        strncpy((char*)$1, temp, SSE_SYMBOL_LEN);
        $1[SSE_SYMBOL_LEN-1] = '\0'; // 确保以null结尾
    } else {
        SWIG_exception(SWIG_TypeError, "string expected");
    }
}

%typemap(out) unsigned char m_symbol[SSE_SYMBOL_LEN] {
    $result = PyString_FromString((const char*)$1);
}

%typemap(memberin) unsigned char m_symbol[SSE_SYMBOL_LEN] {
    strncpy((char*)$1, (const char*)$input, SSE_SYMBOL_LEN);
    $1[SSE_SYMBOL_LEN-1] = '\0';
}


%extend sze_hpf_head {
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }
}

// 暴露 m_bid_unit 和 m_ask_unit 为 Python 可访问的列表
%extend sze_hpf_lev2 {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
    price_quantity_unit get_bid_unit(int i) {
        if (i < 0 || i >= SZE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_bid_unit[i];
    }
    price_quantity_unit get_ask_unit(int i) {
        if (i < 0 || i >= SZE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_ask_unit[i];
    }
}

%extend sze_hpf_idx {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
}

%extend sze_hpf_order {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
}

%extend sze_hpf_exe {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
}

%extend sze_hpf_bond_snap {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
    price_quantity_unit get_bid_unit(int i) {
        if (i < 0 || i >= SZE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_bid_unit[i];
    }
    price_quantity_unit get_ask_unit(int i) {
        if (i < 0 || i >= SZE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_ask_unit[i];
    }
}

%extend sze_hpf_bond_order {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
}

%extend sze_hpf_bond_exe {
    sze_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_head.m_symbol;
    }
}


// 应用typemap到结构体成员
%apply unsigned char m_symbol[SZE_SYMBOL_LEN] { unsigned char m_symbol[SZE_SYMBOL_LEN] };
%apply unsigned char m_symbol[SSE_SYMBOL_LEN] { unsigned char m_symbol[SSE_SYMBOL_LEN] };

// 暴露sse m_bid_unit 和 m_ask_unit 为 Python 可访问的列表
%extend sse_hpf_lev2 {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }
    sse_lev2_price_quantity_unit get_bid_unit(int i) {
        if (i < 0 || i >= SSE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_bid_unit[i];
    }
    sse_lev2_price_quantity_unit get_ask_unit(int i) {
        if (i < 0 || i >= SSE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_ask_unit[i];
    }
}

%extend sse_hpf_idx {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }
}

%extend sse_hpf_exe {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }
}

%extend sse_hpf_order {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }

}

// 暴露sse m_bid_unit 和 m_ask_unit 为 Python 可访问的列表
%extend sse_hpf_bond_snap {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }
    sse_lev2_bond_price_quantity_unit get_bid_unit(int i) {
        if (i < 0 || i >= SSE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_bid_unit[i];
    }
    sse_lev2_bond_price_quantity_unit get_ask_unit(int i) {
        if (i < 0 || i >= SSE_LEV2_DEPTH) throw std::out_of_range("index out of range");
        return self->m_ask_unit[i];
    }
}

%extend sse_hpf_bond_tick {
    sse_hpf_head get_head() {
        return self->m_head;
    }
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }

    // 获取tick_type字符
    char get_tick_type() const {
        return (char)$self->m_tick_type;
    }

}

%extend sse_hpf_tick_merge {
    const char* get_symbol() {
        return (const char*)$self->m_symbol;
    }

    // 获取tick_type字符
    char get_tick_type() const {
        return (char)$self->m_tick_type;
    }

}


// =====================================================
// ============== XLT行情结构体处理 ======================
// =====================================================
%include "xlt_base/xlt_data_type.h"
%include "xlt_base/xlt_trade_struct.h"
%include "xlt_base/xlt_quote_struct.h"
// 为每个具体的字符数组成员指定typemap
// 为结构体添加getter方法
%extend x1::xlt_static_quote_full_info_t {
    // 获取security_code作为Python字符串
    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    // 获取security_name作为Python字符串
    const char* get_security_name() {
        return (const char*)$self->security_name;
    }

    // 获取security_status作为Python字符串
    const char* get_security_status() {
        return (const char*)$self->security_status;
    }
}

// 为结构体添加字符串字段的getter方法
%extend x1::szse_l1_index_t {
    // 获取md_stream_id作为Python字符串
    const char* get_md_stream_id() {
        return (const char*)$self->md_stream_id;
    }

    // 获取security_code作为Python字符串
    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    // 获取security_id_source作为Python字符串
    const char* get_security_id_source() {
        return (const char*)$self->security_id_source;
    }

    // 获取trading_phase_code作为Python字符串
    const char* get_trading_phase_code() {
        return (const char*)$self->trading_phase_code;
    }
}

// 为结构体添加getter方法
%extend x1::szse_l1_snapshot_t {
    // 字符串字段getter
    const char* get_md_stream_id() {
        return (const char*)$self->md_stream_id;
    }

    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    const char* get_security_id_source() {
        return (const char*)$self->security_id_source;
    }

    const char* get_trading_phase_code() {
        return (const char*)$self->trading_phase_code;
    }

    // int64_t数组字段getter - 带下标参数和越界检查
    int64_t get_bid_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_px index out of range (0-4)");
            return 0;
        }
        return $self->bid_px[index];
    }

    int64_t get_bid_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_volume index out of range (0-4)");
            return 0;
        }
        return $self->bid_volume[index];
    }

    int64_t get_offer_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_px index out of range (0-4)");
            return 0;
        }
        return $self->offer_px[index];
    }

    int64_t get_offer_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_volume index out of range (0-4)");
            return 0;
        }
        return $self->offer_volume[index];
    }
}

// 为结构体添加getter方法
%extend x1::szse_l1_snapshot_bond_t {
    // 字符串字段getter
    const char* get_md_stream_id() {
        return (const char*)$self->md_stream_id;
    }

    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    const char* get_security_id_source() {
        return (const char*)$self->security_id_source;
    }

    const char* get_trading_phase_code() {
        return (const char*)$self->trading_phase_code;
    }

    // 二维字符数组getter - sub_trading_phase_code[6][8]
    const char* get_sub_trading_phase_code(int index) {
        if (index < 0 || index >= 6) {
            PyErr_SetString(PyExc_IndexError, "sub_trading_phase_code index out of range (0-5)");
            return "";
        }
        return (const char*)$self->sub_trading_phase_code[index];
    }

    // int64_t数组字段getter - 带下标参数和越界检查
    int64_t get_bid_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_px index out of range (0-4)");
            return 0;
        }
        return $self->bid_px[index];
    }

    int64_t get_bid_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_volume index out of range (0-4)");
            return 0;
        }
        return $self->bid_volume[index];
    }

    int64_t get_offer_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_px index out of range (0-4)");
            return 0;
        }
        return $self->offer_px[index];
    }

    int64_t get_offer_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_volume index out of range (0-4)");
            return 0;
        }
        return $self->offer_volume[index];
    }
}

// 为结构体添加字符串字段的getter方法
%extend x1::sse_l1_index_t {
    // 字符串字段getter
    const char* get_md_stream_id() {
        return (const char*)$self->md_stream_id;
    }

    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    const char* get_trading_phase_code() {
        return (const char*)$self->trading_phase_code;
    }
}

// 为结构体添加getter方法
%extend x1::sse_l1_snapshot_t {
    // 字符串字段getter
    const char* get_md_stream_id() {
        return (const char*)$self->md_stream_id;
    }

    const char* get_security_code() {
        return (const char*)$self->security_code;
    }

    const char* get_trading_phase_code() {
        return (const char*)$self->trading_phase_code;
    }

    // uint64_t数组字段getter - 带下标参数和越界检查
    uint64_t get_bid_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_px index out of range (0-4)");
            return 0;
        }
        return $self->bid_px[index];
    }

    uint64_t get_bid_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "bid_volume index out of range (0-4)");
            return 0;
        }
        return $self->bid_volume[index];
    }

    uint64_t get_offer_px(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_px index out of range (0-4)");
            return 0;
        }
        return $self->offer_px[index];
    }

    uint64_t get_offer_volume(int index) {
        if (index < 0 || index >= 5) {
            PyErr_SetString(PyExc_IndexError, "offer_volume index out of range (0-4)");
            return 0;
        }
        return $self->offer_volume[index];
    }
}



%include cstring.i
%include cdata.i
%include carrays.i
%array_class(x1::xlt_position_info_t, PositionArray);
%array_class(x1::xlt_asset_info_t, AssetArray);
%array_class(x1::xlt_order_info_t, OrderArray);
%array_class(x1::xlt_trade_report_t, TradeArray);
%array_class(x1::xlt_static_quote_full_info_t, StaticQuoteInfoArray);


%feature("director");


%include "xlt_api/sse_hpf_define.h"
%include "xlt_api/sze_hpf_define.h"
%include "xlt_api/xlt_api_config.h"
%include "xlt_api/xlt_api.h"


