import logging

# 配置日志
logging.basicConfig(level=logging.DEBUG, format='%(asctime)s - %(levelname)s - %(message)s')


import py_xlt_api as xlight
import threading


class MyQuoteSpi(xlight.EFHQuoteSpi):
    def __init__(self):
        xlight.EFHQuoteSpi.__init__(self)

    def on_start_quote(self, session_id, error_info:xlight.xlt_error_info_t):
        if error_info and error_info.error_code !=0:
            print("error_code={}, sub_error_code={}, error_msg={}".format(
                error_info.error_code, error_info.sub_error_code, error_info.error_msg))
        else:
            print("success!")

    def on_sse_l1_index(self, sse_l1_index:xlight.sse_l1_index_t):
        print("on_sse_l1_index")
        print("证券代码", sse_l1_index.get_security_code())
        print()

    def on_sse_l1_snapshot(self, sse_l1_snapshot:xlight.sse_l1_snapshot_t):
        print("on_sse_l1_snapshot")
        print("证券代码", sse_l1_snapshot.get_security_code())
        print("买一价",sse_l1_snapshot.get_bid_px(0),"买一量",sse_l1_snapshot.get_bid_volume(0))
        print("卖一价",sse_l1_snapshot.get_offer_px(0),"卖一量",sse_l1_snapshot.get_offer_volume(0))
        print()

    def on_szse_l1_index(self, szse_l1_index:xlight.szse_l1_index_t):
        print("on_szse_l1_index")
        print("证券代码", szse_l1_index.get_security_code())
        print()

    def on_szse_l1_snapshot(self, szse_l1_snapshot:xlight.szse_l1_snapshot_t):
        print("on_szse_l1_snapshot")
        print("证券代码", szse_l1_snapshot.get_security_code())
        print("买一价",szse_l1_snapshot.get_bid_px(0),"买一量",szse_l1_snapshot.get_bid_volume(0))
        print("卖一价",szse_l1_snapshot.get_offer_px(0),"卖一量",szse_l1_snapshot.get_offer_volume(0))
        print()

    def on_szse_l1_snapshot_bond(self, szse_l1_snapshot_bond:xlight.szse_l1_snapshot_bond_t):
        print("on_szse_l1_snapshot_bond")
        print("证券代码", szse_l1_snapshot_bond.get_security_code())
        print("买一价",szse_l1_snapshot_bond.get_bid_px(0),"买一量",szse_l1_snapshot_bond.get_bid_volume(0))
        print("卖一价",szse_l1_snapshot_bond.get_offer_px(0),"卖一量",szse_l1_snapshot_bond.get_offer_volume(0))
        print()

    def on_report_efh_sse_lev2_snap(self, p_snap:xlight.sse_hpf_lev2):
        # return
        print("on_report_efh_sse_lev2_snap")
        sse_head : xlight.sse_hpf_head = p_snap.get_head()
        print("盛立行情序号", sse_head.m_sequence)
        print("保留字段", sse_head.m_reserved_1)
        print("行情类型", sse_head.m_message_type)
        print("包括此消息头的长度", sse_head.m_message_len)
        print("交易所编号", sse_head.m_exchange_id)
        print("行情更新年份", sse_head.m_quote_date_year)
        print("行情更新月份", sse_head.m_quote_date_month)
        print("行情更新日期", sse_head.m_quote_date_day)
        print("交易所发送时间", sse_head.m_send_time)
        print("数据产品类别", sse_head.m_category_id)
        print("行情包序号", sse_head.m_msg_seq_id)
        print("是否丢弃", sse_head.m_seq_lost_flag)
        print("行情更新时间", p_snap.m_quote_update_time)
        print("证券代码", p_snap.get_symbol())
        print("证券类型", p_snap.m_security_type)
        print("快照类型", p_snap.m_image_status)
        print("保留字段", p_snap.m_reserved_1)
        print("昨收价", p_snap.m_pre_close_price)
        print("开盘价", p_snap.m_open_price)
        print("最高价", p_snap.m_day_high_price)
        print("最低价", p_snap.m_day_low_price)
        print("最新价", p_snap.m_last_price)
        print("收盘价", p_snap.m_today_close_price)
        print("当前品种交易状态", p_snap.m_instrument_status)
        print("当前产品状态", p_snap.m_trading_status)
        print("保留字段", p_snap.m_reserved_2)
        print("成交笔数", p_snap.m_total_trade_num)
        print("成交总量", p_snap.m_total_quantity)
        print("成交总额", p_snap.m_total_value)
        print("委托买入总量", p_snap.m_total_bid_quantity)
        print("买方加权平均委买价格", p_snap.m_total_bid_weighted_avg_price)
        print("委托卖出总量", p_snap.m_total_ask_quantity)
        print("卖方加权平均委买价格", p_snap.m_total_ask_weighted_avg_price)
        print("iopv高精度值", p_snap.m_iopv_high_precision)
        print("买盘价位数量", p_snap.m_bid_depth)
        print("卖盘价位数量", p_snap.m_ask_depth)

        print("; ".join(f"买{i+1}:{p_snap.get_bid_unit(i).m_price}, {p_snap.get_bid_unit(i).m_quantity}" for i in range(5)))
        print("; ".join(f"卖{i+1}:{p_snap.get_ask_unit(i).m_price}, {p_snap.get_ask_unit(i).m_quantity}" for i in range(5)))
        print()

    def on_report_efh_sse_lev2_tick_merge(self, p_tick:xlight.sse_hpf_tick_merge):
        print("on_report_efh_sse_lev2_tick_merge")
        print("SSE L2 逐笔合并: {}, 时间: {}, 序号: {}, 类型: {}, 价格: {}, 数量: {}".format(
            p_tick.get_symbol(),
            p_tick.m_tick_time,
            p_tick.m_tick_index,
            p_tick.get_tick_type(),
            p_tick.m_price,
            p_tick.m_quantity))

    def on_report_efh_sse_lev2_idx(self, p_idx:xlight.sse_hpf_idx):
        # return
        print("on_report_efh_sse_lev2_idx")
        print("SSE L2 指数: {}, 时间: {}, 最新指数: {}, 成交量: {}, 成交额: {}".format(
            p_idx.get_symbol(),
            p_idx.m_quote_update_time,
            p_idx.m_last_price,
            p_idx.m_total_quantity,
            p_idx.m_total_value))

    def on_report_efh_sse_lev2_bond_snap(self, p_bond_snap:xlight.sse_hpf_bond_snap):
        # return
        print("on_report_efh_sse_lev2_bond_snap")
        print("SSE L2 债券快照: %s, 时间: {}, 最新价: {}, 成交量: {}, 成交额: {}".format(
            p_bond_snap.get_symbol(),
            p_bond_snap.m_quote_update_time,
            p_bond_snap.m_last_price,
            p_bond_snap.m_total_quantity,
            p_bond_snap.m_total_value
        ))
        print("; ".join(f"买{i+1}:{p_bond_snap.get_bid_unit(i).m_price}, {p_bond_snap.get_bid_unit(i).m_quantity}" for i in range(5)))
        print("; ".join(f"卖{i+1}:{p_bond_snap.get_ask_unit(i).m_price}, {p_bond_snap.get_ask_unit(i).m_quantity}" for i in range(5)))
        print()

    def on_report_efh_sse_lev2_bond_tick(self, p_bond_tick:xlight.sse_hpf_bond_tick):
        print("on_report_efh_sse_lev2_bond_tick")
        print("SSE L2 债券逐笔: {}, 时间: {}, 序号: {}, 类型: {}, 价格: {}, 数量: {}\n".format(
            p_bond_tick.get_symbol(),
            p_bond_tick.m_tick_time,
            p_bond_tick.m_tick_index,
            p_bond_tick.get_tick_type(),
            p_bond_tick.m_price,
            p_bond_tick.m_quantity))

    def on_report_efh_sze_lev2_snap(self, p_snap:xlight.sze_hpf_lev2):
        # return
        print("on_report_efh_sze_lev2_snap")
        sze_head : xlight.sze_hpf_head = p_snap.get_head()
        print("盛立行情序号", sze_head.m_sequence)
        print("保留字段", sze_head.m_reserved_1)
        print("行情类型", sze_head.m_message_type)
        print("证券类型", sze_head.m_security_type)
        print("证券子类型", sze_head.m_sub_security_type)
        print("证券代码", sze_head.get_symbol())
        print("交易所编号", sze_head.m_exchange_id)
        print("行情更新时间", sze_head.m_quote_update_time)
        print("频道号", sze_head.m_channel_num)
        print("包序号", sze_head.m_sequence_num)
        print("行情类别", sze_head.m_md_stream_id)
        print("交易状态码", p_snap.m_trading_status)
        print("成交笔数", p_snap.m_total_trade_num)
        print("总成交量", p_snap.m_total_quantity)
        print("总成交额", p_snap.m_total_value)
        print("昨收价", p_snap.m_pre_close_price)
        print("最新价", p_snap.m_last_price)
        print("开盘价", p_snap.m_open_price)
        print("最高价", p_snap.m_day_high_price)
        print("最低价", p_snap.m_day_low_price)
        print("收盘价", p_snap.m_today_close_price)
        print("买方挂单均价", p_snap.m_total_bid_weighted_avg_price)
        print("买总量", p_snap.m_total_bid_quantity)
        print("卖方挂单均价", p_snap.m_total_ask_weighted_avg_price)
        print("卖总量", p_snap.m_total_ask_quantity)
        print("基金 T-1 日净值", p_snap.m_lpv)
        print("基金实时参考净值", p_snap.m_iopv)
        print("涨停价", p_snap.m_upper_limit_price)
        print("跌停价", p_snap.m_low_limit_price)
        print("合约持仓量", p_snap.m_open_interest)
        print("; ".join(f"买{i+1}:{p_snap.get_bid_unit(i).m_price}, {p_snap.get_bid_unit(i).m_quantity}" for i in range(5)))
        print("; ".join(f"卖{i+1}:{p_snap.get_ask_unit(i).m_price}, {p_snap.get_ask_unit(i).m_quantity}" for i in range(5)))
        print()

    def on_report_efh_sze_lev2_tick(self, msg_type, p_order:xlight.sze_hpf_order, p_exe:xlight.sze_hpf_exe):
        print("on_report_efh_sze_lev2_tick")
        print("类型", msg_type)
        if msg_type == xlight.SZE_LEV2_ORDER_MSG_TYPE:
            print("订单信息")
            print("证券代码", p_order.get_symbol())
            print("价格", p_order.m_order_price)
            print("数量", p_order.m_order_quantity)
            print("方向", p_order.m_side_flag)
            print("订单类型", p_order.m_order_type)
        else:
            print("成交信息")
            print("证券代码", p_exe.get_symbol())
            print("买方包序号", p_exe.m_trade_buy_num)
            print("卖方包序号", p_exe.m_trade_sell_num)
            print("价格", p_exe.m_trade_price)
            print("数量", p_exe.m_trade_quantity)
            print("成交类型", p_exe.m_trade_type)

    def on_report_efh_sze_lev2_idx(self, p_idx:xlight.sze_hpf_idx):
        # return
        print("on_report_efh_sze_lev2_idx")
        print("订单信息")
        print("证券代码", p_idx.get_symbol())

    def on_report_efh_sze_lev2_bond_snap(self, p_bond_snap:xlight.sze_hpf_bond_snap):
        # return
        print("on_report_efh_sze_lev2_bond_snap")
        print("证券代码", p_bond_snap.get_symbol())
        print("; ".join(f"买{i+1}:{p_bond_snap.get_bid_unit(i).m_price}, {p_bond_snap.get_bid_unit(i).m_quantity}" for i in range(5)))
        print("; ".join(f"卖{i+1}:{p_bond_snap.get_ask_unit(i).m_price}, {p_bond_snap.get_ask_unit(i).m_quantity}" for i in range(5)))

    def on_report_efh_sze_lev2_bond_tick(self, msg_type, p_order:xlight.sze_hpf_bond_order, p_exe:xlight.sze_hpf_bond_exe):
        print("on_report_efh_sze_lev2_bond_tick")
        if msg_type == xlight.SZE_LEV2_BOND_ORDER_MSG_TYPE:
            print("订单信息")
            print("证券代码", p_order.get_symbol())
            print("价格", p_order.m_price)
            print("数量", p_order.m_quantity)
            print("方向", p_order.m_side)
            print("订单类型", p_order.m_order_type)
        else:
            print("成交信息")
            print("证券代码", p_exe.get_symbol())
            print("买方包序号", p_exe.m_buy_num)
            print("卖方包序号", p_exe.m_sell_num)
            print("价格", p_exe.m_price)
            print("数量", p_exe.m_quantity)
            print("成交类型", p_exe.m_type)



