#include <atomic>
#include <cstring>
#include <cstdio>
#include "xlt_api.h"

using namespace x1;
extern XLTApi * my_xapi;                 ///< API实例，全局唯一
extern uint64_t global_session_id;              ///< 会话ID
extern std::atomic<bool> global_login_success;   ///< 是否正在登录标识
extern std::atomic<bool> global_login_finished;  ///< 已建立会话标识
extern std::atomic<uint64_t> global_request_id;  ///< 全局请求id

extern uint64_t next_request_id();

class MyTradeSpi : public XLTTradeSpi {
public:
    using XLTTradeSpi::XLTTradeSpi;
    void on_disconnect(uint64_t session_id) override;
    void on_login(uint64_t session_id, uint64_t request_id, xlt_error_info_t *error_info) override;
    void on_order_end(uint64_t session_id, xlt_order_end_t *order_end) override;
    void on_order_response(uint64_t session_id, xlt_order_response_t* order_response) override;
    void on_cancel_response(uint64_t session_id, xlt_cancel_response_t *cancel_response) override;
    void on_trade_report(uint64_t session_id, xlt_trade_report_t *trade_report) override;
    void on_order_error_response(uint64_t session_id, xlt_order_error_response_t *order_error_response) override;
    void on_raw_report(uint64_t session_id, uint8_t client_id, uint64_t xid, char report_id[32], uint64_t sequence, ExchangeIndex exchange_index, uint32_t
                       report_size, char* raw_report) override;
    void on_query_positions(uint64_t session_id, uint64_t request_id, xlt_position_info_t positions[], uint32_t data_count, bool is_last, xlt_error_info_t *error_info) override;
    void on_query_assets(uint64_t session_id, uint64_t request_id, xlt_asset_info_t assets[], uint32_t data_count, bool is_last, xlt_error_info_t *error_info) override;
    void on_query_orders(uint64_t session_id, uint64_t request_id, xlt_order_info_t order_infos[], uint32_t data_count, bool is_last, xlt_error_info_t *error_info) override;
    void on_query_orders_by_page(uint64_t session_id, uint64_t request_id, xlt_order_info_t order_infos[], uint64_t data_count, uint64_t req_count, uint64_t rsp_count, uint64_t query_reference, bool is_last, xlt_error_info_t *error_info) override;
    void on_query_trades(uint64_t session_id, uint64_t request_id, xlt_trade_report_t trade_reports[], uint32_t data_count, bool is_last, xlt_error_info_t *error_info) override;
    void on_query_static_quote_info(uint64_t session_id, uint64_t request_id, xlt_static_quote_full_info_t static_quote_full_infos[], uint32_t data_count, bool is_last, xlt_error_info_t* error_info) override;
    void on_query_sse_l1_index(uint64_t session_id, uint64_t request_id, sse_l1_index_t* sse_l1_index, xlt_error_info_t* error_info) override;
    void on_query_sse_l1_snapshot(uint64_t session_id, uint64_t request_id, sse_l1_snapshot_t* sse_l1_snapshot, xlt_error_info_t* error_info) override;
    void on_query_szse_l1_index(uint64_t session_id, uint64_t request_id, szse_l1_index_t* szse_l1_index, xlt_error_info_t* error_info) override;
    void on_query_szse_l1_snapshot(uint64_t session_id, uint64_t request_id, szse_l1_snapshot_t* szse_l1_snapshot, xlt_error_info_t* error_info) override;
    void on_query_szse_l1_snapshot_bond(uint64_t session_id, uint64_t request_id, szse_l1_snapshot_bond_t* szse_l1_snapshot_bond, xlt_error_info_t* error_info) override;
    void on_order_timeout(uint64_t session_id, uint64_t xid) override;
    void on_request_timeout(uint64_t session_id, uint64_t request_id) override;

};
