#include "my_quote_spi.h"

#include <cstdio>

void MyQuoteSpi::on_start_quote(uint64_t session_id,
                                xlt_error_info_t *error_info) {
    if (error_info->error_code!=0) {
        printf("on_start_quote error_code: %lu, sub_error_code: %lu, error_info: %s\n", error_info->error_code, error_info->sub_error_code, error_info->error_msg);
        printf("\n");
    } else {
        printf("on_start_quote success! session_id: %lu\n", session_id);
        printf("\n");
    }

}

void MyQuoteSpi::on_sse_l1_index(const sse_l1_index_t* sse_l1_index)
{
    if (!sse_l1_index) return;
    printf("on_sse_l1_index\n");
    printf("security_type: %u\n", sse_l1_index->security_type);
    printf("sending_time: %llu\n", (unsigned long long)sse_l1_index->sending_time);
    printf("trad_ses_mode: %u\n", sse_l1_index->trad_ses_mode);
    printf("trade_date: %u\n", sse_l1_index->trade_date);
    printf("last_update_time: %u\n", sse_l1_index->last_update_time);
    printf("md_stream_id: %.*s\n", 5, sse_l1_index->md_stream_id);
    printf("security_code: %.*s\n", CONST_STR_SECURITY_CODE_LEN, sse_l1_index->security_code);
    printf("prev_close_px: %llu\n", (unsigned long long)sse_l1_index->prev_close_px);
    printf("total_volume_traded: %llu\n", (unsigned long long)sse_l1_index->total_volume_traded);
    printf("num_trades: %llu\n", (unsigned long long)sse_l1_index->num_trades);
    printf("total_value_traded: %llu\n", (unsigned long long)sse_l1_index->total_value_traded);
    printf("trading_phase_code: %.*s\n", 8, sse_l1_index->trading_phase_code);
    printf("last_px: %llu\n", (unsigned long long)sse_l1_index->last_px);
    printf("open_px: %llu\n", (unsigned long long)sse_l1_index->open_px);
    printf("close_px: %llu\n", (unsigned long long)sse_l1_index->close_px);
    printf("high_px: %llu\n", (unsigned long long)sse_l1_index->high_px);
    printf("low_px: %llu\n", (unsigned long long)sse_l1_index->low_px);
    printf("\n");
}

void MyQuoteSpi::on_sse_l1_snapshot(const sse_l1_snapshot_t* sse_l1_snapshot)
{
    if (!sse_l1_snapshot) return;
    printf("on_sse_l1_snapshot\n");
    printf("security_type: %u\n", sse_l1_snapshot->security_type);
    printf("sending_time: %llu\n", (unsigned long long)sse_l1_snapshot->sending_time);
    printf("trad_ses_mode: %u\n", sse_l1_snapshot->trad_ses_mode);
    printf("trade_date: %u\n", sse_l1_snapshot->trade_date);
    printf("last_update_time: %u\n", sse_l1_snapshot->last_update_time);
    printf("md_stream_id: %.*s\n", 5, sse_l1_snapshot->md_stream_id);
    printf("security_code: %.*s\n", CONST_STR_SECURITY_CODE_LEN, sse_l1_snapshot->security_code);
    printf("prev_close_px: %llu\n", (unsigned long long)sse_l1_snapshot->prev_close_px);
    printf("total_volume_traded: %llu\n", (unsigned long long)sse_l1_snapshot->total_volume_traded);
    printf("num_trades: %llu\n", (unsigned long long)sse_l1_snapshot->num_trades);
    printf("total_value_traded: %llu\n", (unsigned long long)sse_l1_snapshot->total_value_traded);
    printf("trading_phase_code: %.*s\n", 8, sse_l1_snapshot->trading_phase_code);
    printf("last_px: %llu\n", (unsigned long long)sse_l1_snapshot->last_px);
    printf("open_px: %llu\n", (unsigned long long)sse_l1_snapshot->open_px);
    printf("close_px: %llu\n", (unsigned long long)sse_l1_snapshot->close_px);
    printf("settle_px: %llu\n", (unsigned long long)sse_l1_snapshot->settle_px);
    printf("high_px: %llu\n", (unsigned long long)sse_l1_snapshot->high_px);
    printf("low_px: %llu\n", (unsigned long long)sse_l1_snapshot->low_px);
    printf("iopv: %llu\n", (unsigned long long)sse_l1_snapshot->iopv);
    printf("pre_iopv: %llu\n", (unsigned long long)sse_l1_snapshot->pre_iopv);
    printf("option_ref_px: %llu\n", (unsigned long long)sse_l1_snapshot->option_ref_px);
    printf("option_notional_amount: %llu\n", (unsigned long long)sse_l1_snapshot->option_notional_amount);
    printf("pre_settle_px: %llu\n", (unsigned long long)sse_l1_snapshot->pre_settle_px);
    printf("option_open_qty: %llu\n", (unsigned long long)sse_l1_snapshot->option_open_qty);

    for (int i = 0; i < 5; ++i) {
        printf("bid_px[%d]: %llu\n", i, (unsigned long long)sse_l1_snapshot->bid_px[i]);
        printf("bid_volume[%d]: %llu\n", i, (unsigned long long)sse_l1_snapshot->bid_volume[i]);
    }

    for (int i = 0; i < 5; ++i) {
        printf("offer_px[%d]: %llu\n", i, (unsigned long long)sse_l1_snapshot->offer_px[i]);
        printf("offer_volume[%d]: %llu\n", i, (unsigned long long)sse_l1_snapshot->offer_volume[i]);
    }
    printf("\n");
}

void MyQuoteSpi::on_szse_l1_index(const szse_l1_index_t* szse_l1_index)
{
    if (!szse_l1_index) return;
    printf("on_szse_l1_index\n");
    printf("channel_no: %u\n", szse_l1_index->channel_no);
    printf("orig_time: %lld\n", (long long)szse_l1_index->orig_time);
    printf("md_stream_id: %.*s\n", 3, szse_l1_index->md_stream_id);
    printf("security_code: %.*s\n", CONST_STR_SECURITY_CODE_LEN, szse_l1_index->security_code);
    printf("security_id_source: %.*s\n", 4, szse_l1_index->security_id_source);
    printf("trading_phase_code: %.*s\n", 8, szse_l1_index->trading_phase_code);
    printf("prev_close_px: %lld\n", (long long)szse_l1_index->prev_close_px);
    printf("num_trades: %lld\n", (long long)szse_l1_index->num_trades);
    printf("total_volume_trade: %lld\n", (long long)szse_l1_index->total_volume_trade);
    printf("total_value_trade: %lld\n", (long long)szse_l1_index->total_value_trade);
    printf("last_index: %lld\n", (long long)szse_l1_index->last_index);
    printf("prev_close_index: %lld\n", (long long)szse_l1_index->prev_close_index);
    printf("open_index: %lld\n", (long long)szse_l1_index->open_index);
    printf("high_index: %lld\n", (long long)szse_l1_index->high_index);
    printf("low_index: %lld\n", (long long)szse_l1_index->low_index);
    printf("close_index: %lld\n", (long long)szse_l1_index->close_index);
    printf("\n");
}

void MyQuoteSpi::on_szse_l1_snapshot(const szse_l1_snapshot_t* szse_l1_snapshot)
{
    if (!szse_l1_snapshot) return;
    printf("on_szse_l1_snapshot\n");
    printf("channel_no: %u\n", szse_l1_snapshot->channel_no);
    printf("orig_time: %lld\n", (long long)szse_l1_snapshot->orig_time);
    printf("md_stream_id: %.*s\n", 3, szse_l1_snapshot->md_stream_id);
    printf("security_code: %.*s\n", CONST_STR_SECURITY_CODE_LEN, szse_l1_snapshot->security_code);
    printf("security_id_source: %.*s\n", 4, szse_l1_snapshot->security_id_source);
    printf("trading_phase_code: %.*s\n", 8, szse_l1_snapshot->trading_phase_code);
    printf("prev_close_px: %lld\n", (long long)szse_l1_snapshot->prev_close_px);
    printf("num_trades: %lld\n", (long long)szse_l1_snapshot->num_trades);
    printf("total_volume_trade: %lld\n", (long long)szse_l1_snapshot->total_volume_trade);
    printf("total_value_trade: %lld\n", (long long)szse_l1_snapshot->total_value_trade);
    printf("last_px: %lld\n", (long long)szse_l1_snapshot->last_px);
    printf("open_px: %lld\n", (long long)szse_l1_snapshot->open_px);
    printf("high_px: %lld\n", (long long)szse_l1_snapshot->high_px);
    printf("low_px: %lld\n", (long long)szse_l1_snapshot->low_px);
    printf("px_gain: %lld\n", (long long)szse_l1_snapshot->px_gain);
    printf("px_gain_2: %lld\n", (long long)szse_l1_snapshot->px_gain_2);
    printf("weighted_avg_bid_px: %lld\n", (long long)szse_l1_snapshot->weighted_avg_bid_px);
    printf("total_bid_qty: %lld\n", (long long)szse_l1_snapshot->total_bid_qty);
    printf("weighted_avg_offer_px: %lld\n", (long long)szse_l1_snapshot->weighted_avg_offer_px);
    printf("total_offer_qty: %lld\n", (long long)szse_l1_snapshot->total_offer_qty);
    printf("pe_ratio_1: %lld\n", (long long)szse_l1_snapshot->pe_ratio_1);
    printf("pe_ratio_2: %lld\n", (long long)szse_l1_snapshot->pe_ratio_2);
    printf("nav: %lld\n", (long long)szse_l1_snapshot->nav);
    printf("iopv: %lld\n", (long long)szse_l1_snapshot->iopv);
    printf("warrant_premium: %lld\n", (long long)szse_l1_snapshot->warrant_premium);
    printf("limit_up_px: %lld\n", (long long)szse_l1_snapshot->limit_up_px);
    printf("limit_down_px: %lld\n", (long long)szse_l1_snapshot->limit_down_px);
    printf("option_open_qty: %lld\n", (long long)szse_l1_snapshot->option_open_qty);
    printf("option_break_px: %lld\n", (long long)szse_l1_snapshot->option_break_px);

    for (int i = 0; i < 5; ++i) {
        printf("bid_px[%d]: %lld\n", i, (long long)szse_l1_snapshot->bid_px[i]);
        printf("bid_volume[%d]: %lld\n", i, (long long)szse_l1_snapshot->bid_volume[i]);
    }

    for (int i = 0; i < 5; ++i) {
        printf("offer_px[%d]: %lld\n", i, (long long)szse_l1_snapshot->offer_px[i]);
        printf("offer_volume[%d]: %lld\n", i, (long long)szse_l1_snapshot->offer_volume[i]);
    }
    printf("\n");
}

void MyQuoteSpi::on_szse_l1_snapshot_bond(const szse_l1_snapshot_bond_t* szse_l1_snapshot_bond)
{
    if (!szse_l1_snapshot_bond) return;
    printf("on_szse_l1_snapshot_bond\n");
    printf("channel_no: %u\n", szse_l1_snapshot_bond->channel_no);
    printf("orig_time: %lld\n", (long long)szse_l1_snapshot_bond->orig_time);
    printf("md_stream_id: %.*s\n", 3, szse_l1_snapshot_bond->md_stream_id);
    printf("security_code: %.*s\n", CONST_STR_SECURITY_CODE_LEN, szse_l1_snapshot_bond->security_code);
    printf("security_id_source: %.*s\n", 4, szse_l1_snapshot_bond->security_id_source);
    printf("trading_phase_code: %.*s\n", 8, szse_l1_snapshot_bond->trading_phase_code);
    printf("prev_close_px: %lld\n", (long long)szse_l1_snapshot_bond->prev_close_px);
    printf("num_trades: %lld\n", (long long)szse_l1_snapshot_bond->num_trades);
    printf("total_volume_trade: %lld\n", (long long)szse_l1_snapshot_bond->total_volume_trade);
    printf("total_value_trade: %lld\n", (long long)szse_l1_snapshot_bond->total_value_trade);
    printf("last_px: %lld\n", (long long)szse_l1_snapshot_bond->last_px);
    printf("open_px: %lld\n", (long long)szse_l1_snapshot_bond->open_px);
    printf("close_px: %lld\n", (long long)szse_l1_snapshot_bond->close_px);
    printf("high_px: %lld\n", (long long)szse_l1_snapshot_bond->high_px);
    printf("low_px: %lld\n", (long long)szse_l1_snapshot_bond->low_px);
    printf("weighted_avg_px: %lld\n", (long long)szse_l1_snapshot_bond->weighted_avg_px);
    printf("px_gain: %lld\n", (long long)szse_l1_snapshot_bond->px_gain);
    printf("px_gain_2: %lld\n", (long long)szse_l1_snapshot_bond->px_gain_2);
    printf("weighted_avg_bid_px: %lld\n", (long long)szse_l1_snapshot_bond->weighted_avg_bid_px);
    printf("total_bid_qty: %lld\n", (long long)szse_l1_snapshot_bond->total_bid_qty);
    printf("weighted_avg_offer_px: %lld\n", (long long)szse_l1_snapshot_bond->weighted_avg_offer_px);
    printf("total_offer_qty: %lld\n", (long long)szse_l1_snapshot_bond->total_offer_qty);
    printf("weighted_avg_ir_gain: %lld\n", (long long)szse_l1_snapshot_bond->weighted_avg_ir_gain);
    printf("weighted_avg_prev_ir: %lld\n", (long long)szse_l1_snapshot_bond->weighted_avg_prev_ir);
    printf("match_last_px: %lld\n", (long long)szse_l1_snapshot_bond->match_last_px);
    printf("auction_volume_trade: %lld\n", (long long)szse_l1_snapshot_bond->auction_volume_trade);
    printf("auction_value_trade: %lld\n", (long long)szse_l1_snapshot_bond->auction_value_trade);

    for (int i = 0; i < 6; ++i) {
        printf("sub_trading_phase_code[%d]: %.*s\n", i, 8, szse_l1_snapshot_bond->sub_trading_phase_code[i]);
    }

    for (int i = 0; i < 5; ++i) {
        printf("bid_px[%d]: %lld\n", i, (long long)szse_l1_snapshot_bond->bid_px[i]);
        printf("bid_volume[%d]: %lld\n", i, (long long)szse_l1_snapshot_bond->bid_volume[i]);
    }

    for (int i = 0; i < 5; ++i) {
        printf("offer_px[%d]: %lld\n", i, (long long)szse_l1_snapshot_bond->offer_px[i]);
        printf("offer_volume[%d]: %lld\n", i, (long long)szse_l1_snapshot_bond->offer_volume[i]);
    }
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sse_lev2_snap(const sse_hpf_lev2* p_snap)
{
    if (!p_snap) {
        return;
    }
    printf("SSE L2 快照: %s, 时间: %u, 最新价: %u, 成交量: %llu, 成交额: %llu\n",
           p_snap->m_symbol,
           p_snap->m_quote_update_time,
           p_snap->m_last_price,
           p_snap->m_total_quantity,
           p_snap->m_total_value);
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sse_lev2_tick_merge(const sse_hpf_tick_merge* p_tick)
{
    if (!p_tick) {
        return;
    }
    printf("SSE L2 逐笔合并: %s, 时间: %u, 序号: %llu, 类型: %c, 价格: %u, 数量: %llu\n",
           p_tick->m_symbol,
           p_tick->m_tick_time,
           p_tick->m_tick_index,
           p_tick->m_tick_type,
           p_tick->m_price,
           p_tick->m_quantity);
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sse_lev2_idx(const sse_hpf_idx* p_idx)
{
    if (!p_idx) {
        return;
    }
    printf("SSE L2 指数: %s, 时间: %u, 最新指数: %u, 成交量: %llu, 成交额: %llu\n",
           p_idx->m_symbol,
           p_idx->m_quote_update_time,
           p_idx->m_last_price,
           p_idx->m_total_quantity,
           p_idx->m_total_value);
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sse_lev2_bond_snap(const sse_hpf_bond_snap* p_bond_snap)
{
    if (!p_bond_snap) {
        return;
    }
    printf("SSE L2 债券快照: %s, 时间: %u, 最新价: %u, 成交量: %llu, 成交额: %llu\n",
           p_bond_snap->m_symbol,
           p_bond_snap->m_quote_update_time,
           p_bond_snap->m_last_price,
           p_bond_snap->m_total_quantity,
           p_bond_snap->m_total_value);
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sse_lev2_bond_tick(const sse_hpf_bond_tick* p_bond_tick)
{
    if (!p_bond_tick) {
        return;
    }
    printf("SSE L2 债券逐笔: %s, 时间: %u, 序号: %u, 类型: %c, 价格: %u, 数量: %llu\n",
           p_bond_tick->m_symbol,
           p_bond_tick->m_tick_time,
           p_bond_tick->m_tick_index,
           p_bond_tick->m_tick_type,
           p_bond_tick->m_price,
           p_bond_tick->m_quantity);
    printf("\n");
}


void MyQuoteSpi::on_report_efh_sze_lev2_snap(const sze_hpf_lev2* p_snap) {
    printf("m_head.m_sequence: %u\n", p_snap->m_head.m_sequence);
    printf("m_head.m_reserved_1: %u\n", p_snap->m_head.m_reserved_1);
    printf("m_head.m_message_type: %u\n", p_snap->m_head.m_message_type);
    printf("m_head.m_security_type: %u\n", p_snap->m_head.m_security_type);
    printf("m_head.m_sub_security_type: %u\n", p_snap->m_head.m_sub_security_type);
    printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_snap->m_head.m_symbol);
    printf("m_head.m_exchange_id: %u\n", p_snap->m_head.m_exchange_id);
    printf("m_head.m_quote_update_time: %llu\n", p_snap->m_head.m_quote_update_time);
    printf("m_head.m_channel_num: %u\n", p_snap->m_head.m_channel_num);
    printf("m_head.m_sequence_num: %llu\n", p_snap->m_head.m_sequence_num);
    printf("m_head.m_md_stream_id: %u\n", p_snap->m_head.m_md_stream_id);

    printf("m_trading_status: %u\n", p_snap->m_trading_status);
    printf("m_total_trade_num: %llu\n", p_snap->m_total_trade_num);
    printf("m_total_quantity: %llu\n", p_snap->m_total_quantity);
    printf("m_total_value: %llu\n", p_snap->m_total_value);
    printf("m_pre_close_price: %u\n", p_snap->m_pre_close_price);
    printf("m_last_price: %u\n", p_snap->m_last_price);
    printf("m_open_price: %u\n", p_snap->m_open_price);
    printf("m_day_high_price: %u\n", p_snap->m_day_high_price);
    printf("m_day_low_price: %u\n", p_snap->m_day_low_price);
    printf("m_today_close_price: %u\n", p_snap->m_today_close_price);
    printf("m_total_bid_weighted_avg_price: %u\n", p_snap->m_total_bid_weighted_avg_price);
    printf("m_total_bid_quantity: %llu\n", p_snap->m_total_bid_quantity);
    printf("m_total_ask_weighted_avg_price: %u\n", p_snap->m_total_ask_weighted_avg_price);
    printf("m_total_ask_quantity: %llu\n", p_snap->m_total_ask_quantity);
    printf("m_lpv: %u\n", p_snap->m_lpv);
    printf("m_iopv: %u\n", p_snap->m_iopv);
    printf("m_upper_limit_price: %u\n", p_snap->m_upper_limit_price);
    printf("m_low_limit_price: %u\n", p_snap->m_low_limit_price);
    printf("m_open_interest: %u\n", p_snap->m_open_interest);

    for (int i = 0; i < SZE_LEV2_DEPTH; ++i) {
        printf("m_bid_unit[%d].m_price: %u, m_bid_unit[%d].m_quantity: %llu\n",
               i, p_snap->m_bid_unit[i].m_price, i, p_snap->m_bid_unit[i].m_quantity);
    }
    for (int i = 0; i < SZE_LEV2_DEPTH; ++i) {
        printf("m_ask_unit[%d].m_price: %u, m_ask_unit[%d].m_quantity: %llu\n",
               i, p_snap->m_ask_unit[i].m_price, i, p_snap->m_ask_unit[i].m_quantity);
    }
    printf("\n");
}

void MyQuoteSpi::on_report_efh_sze_lev2_tick(int msg_type, const sze_hpf_order* p_order, const sze_hpf_exe* p_exe) {
    if (msg_type == SZE_LEV2_ORDER_MSG_TYPE && p_order) {
        printf("sze_hpf_order:\n");
        printf("m_head.m_sequence: %u\n", p_order->m_head.m_sequence);
        printf("m_head.m_reserved_1: %u\n", p_order->m_head.m_reserved_1);
        printf("m_head.m_message_type: %u\n", p_order->m_head.m_message_type);
        printf("m_head.m_security_type: %u\n", p_order->m_head.m_security_type);
        printf("m_head.m_sub_security_type: %u\n", p_order->m_head.m_sub_security_type);
        printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_order->m_head.m_symbol);
        printf("m_head.m_exchange_id: %u\n", p_order->m_head.m_exchange_id);
        printf("m_head.m_quote_update_time: %llu\n", p_order->m_head.m_quote_update_time);
        printf("m_head.m_channel_num: %u\n", p_order->m_head.m_channel_num);
        printf("m_head.m_sequence_num: %llu\n", p_order->m_head.m_sequence_num);
        printf("m_head.m_md_stream_id: %u\n", p_order->m_head.m_md_stream_id);

        printf("m_order_price: %u\n", p_order->m_order_price);
        printf("m_order_quantity: %llu\n", p_order->m_order_quantity);
        printf("m_side_flag: %c\n", p_order->m_side_flag);
        printf("m_order_type: %c\n", p_order->m_order_type);
        printf("m_reserved: ");
        for (int i = 0; i < 15; ++i) {
            printf("%02x ", (unsigned char)p_order->m_reserved[i]);
        }
        printf("\n");
    } else if (msg_type == SZE_LEV2_EXE_MSG_TYPE && p_exe) {
        printf("sze_hpf_exe:\n");
        printf("m_head.m_sequence: %u\n", p_exe->m_head.m_sequence);
        printf("m_head.m_reserved_1: %u\n", p_exe->m_head.m_reserved_1);
        printf("m_head.m_message_type: %u\n", p_exe->m_head.m_message_type);
        printf("m_head.m_security_type: %u\n", p_exe->m_head.m_security_type);
        printf("m_head.m_sub_security_type: %u\n", p_exe->m_head.m_sub_security_type);
        printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_exe->m_head.m_symbol);
        printf("m_head.m_exchange_id: %u\n", p_exe->m_head.m_exchange_id);
        printf("m_head.m_quote_update_time: %llu\n", p_exe->m_head.m_quote_update_time);
        printf("m_head.m_channel_num: %u\n", p_exe->m_head.m_channel_num);
        printf("m_head.m_sequence_num: %llu\n", p_exe->m_head.m_sequence_num);
        printf("m_head.m_md_stream_id: %u\n", p_exe->m_head.m_md_stream_id);

        printf("m_trade_buy_num: %lld\n", p_exe->m_trade_buy_num);
        printf("m_trade_sell_num: %lld\n", p_exe->m_trade_sell_num);
        printf("m_trade_price: %u\n", p_exe->m_trade_price);
        printf("m_trade_quantity: %lld\n", p_exe->m_trade_quantity);
        printf("m_trade_type: %c\n", p_exe->m_trade_type);
    }
    printf("\n");
}

// 指数消息
void MyQuoteSpi::on_report_efh_sze_lev2_idx(const sze_hpf_idx* p_idx) {
    printf("m_head.m_sequence: %u\n", p_idx->m_head.m_sequence);
    printf("m_head.m_reserved_1: %u\n", p_idx->m_head.m_reserved_1);
    printf("m_head.m_message_type: %u\n", p_idx->m_head.m_message_type);
    printf("m_head.m_security_type: %u\n", p_idx->m_head.m_security_type);
    printf("m_head.m_sub_security_type: %u\n", p_idx->m_head.m_sub_security_type);
    printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_idx->m_head.m_symbol);
    printf("m_head.m_exchange_id: %u\n", p_idx->m_head.m_exchange_id);
    printf("m_head.m_quote_update_time: %llu\n", p_idx->m_head.m_quote_update_time);
    printf("m_head.m_channel_num: %u\n", p_idx->m_head.m_channel_num);
    printf("m_head.m_sequence_num: %llu\n", p_idx->m_head.m_sequence_num);
    printf("m_head.m_md_stream_id: %u\n", p_idx->m_head.m_md_stream_id);

    printf("m_total_trade_num: %llu\n", p_idx->m_total_trade_num);
    printf("m_total_quantity: %llu\n", p_idx->m_total_quantity);
    printf("m_total_value: %llu\n", p_idx->m_total_value);
    printf("m_last_price: %u\n", p_idx->m_last_price);
    printf("m_pre_close_price: %u\n", p_idx->m_pre_close_price);
    printf("m_open_price: %u\n", p_idx->m_open_price);
    printf("m_day_high_price: %u\n", p_idx->m_day_high_price);
    printf("m_day_low_price: %u\n", p_idx->m_day_low_price);
    printf("m_today_close_price: %u\n", p_idx->m_today_close_price);
    printf("m_reserved: %02x %02x %02x %02x %02x\n",
           p_idx->m_reserved[0], p_idx->m_reserved[1], p_idx->m_reserved[2], p_idx->m_reserved[3], p_idx->m_reserved[4]);
    printf("\n");
}

// 债券快照
void MyQuoteSpi::on_report_efh_sze_lev2_bond_snap(const sze_hpf_bond_snap* p_bond_snap) {
    printf("m_head.m_sequence: %u\n", p_bond_snap->m_head.m_sequence);
    printf("m_head.m_reserved_1: %u\n", p_bond_snap->m_head.m_reserved_1);
    printf("m_head.m_message_type: %u\n", p_bond_snap->m_head.m_message_type);
    printf("m_head.m_security_type: %u\n", p_bond_snap->m_head.m_security_type);
    printf("m_head.m_sub_security_type: %u\n", p_bond_snap->m_head.m_sub_security_type);
    printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_bond_snap->m_head.m_symbol);
    printf("m_head.m_exchange_id: %u\n", p_bond_snap->m_head.m_exchange_id);
    printf("m_head.m_quote_update_time: %llu\n", p_bond_snap->m_head.m_quote_update_time);
    printf("m_head.m_channel_num: %u\n", p_bond_snap->m_head.m_channel_num);
    printf("m_head.m_sequence_num: %llu\n", p_bond_snap->m_head.m_sequence_num);
    printf("m_head.m_md_stream_id: %u\n", p_bond_snap->m_head.m_md_stream_id);

    printf("m_trading_status: %u\n", p_bond_snap->m_trading_status);
    printf("m_total_trade_num: %llu\n", p_bond_snap->m_total_trade_num);
    printf("m_total_quantity: %llu\n", p_bond_snap->m_total_quantity);
    printf("m_total_value: %llu\n", p_bond_snap->m_total_value);
    printf("m_pre_close_price: %u\n", p_bond_snap->m_pre_close_price);
    printf("m_last_price: %u\n", p_bond_snap->m_last_price);
    printf("m_open_price: %u\n", p_bond_snap->m_open_price);
    printf("m_day_high_price: %u\n", p_bond_snap->m_day_high_price);
    printf("m_day_low_price: %u\n", p_bond_snap->m_day_low_price);
    printf("m_today_close_price: %u\n", p_bond_snap->m_today_close_price);
    printf("m_total_trade_weighted_avg_price: %u\n", p_bond_snap->m_total_trade_weighted_avg_price);
    printf("m_fluctuation_1: %d\n", p_bond_snap->m_fluctuation_1);
    printf("m_fluctuation_2: %d\n", p_bond_snap->m_fluctuation_2);
    printf("m_total_bid_weighted_avg_price: %u\n", p_bond_snap->m_total_bid_weighted_avg_price);
    printf("m_total_bid_quantity: %llu\n", p_bond_snap->m_total_bid_quantity);
    printf("m_total_ask_weighted_avg_price: %u\n", p_bond_snap->m_total_ask_weighted_avg_price);
    printf("m_total_ask_quantity: %llu\n", p_bond_snap->m_total_ask_quantity);
    printf("m_weighted_avg_price_BP: %d\n", p_bond_snap->m_weighted_avg_price_BP);
    printf("m_weighted_avg_pre_close_price: %u\n", p_bond_snap->m_weighted_avg_pre_close_price);
    printf("m_auction_trade_last_price: %u\n", p_bond_snap->m_auction_trade_last_price);
    printf("m_reserved: %02x %02x %02x %02x\n",
           p_bond_snap->m_reserved[0], p_bond_snap->m_reserved[1], p_bond_snap->m_reserved[2], p_bond_snap->m_reserved[3]);
    printf("m_auction_volume_trade: %llu\n", p_bond_snap->m_auction_volume_trade);
    printf("m_auction_value_trade: %llu\n", p_bond_snap->m_auction_value_trade);
    for (int i = 0; i < SZE_LEV2_DEPTH; ++i) {
        printf("m_bid_unit[%d].m_price: %u, m_bid_unit[%d].m_quantity: %llu\n",
               i, p_bond_snap->m_bid_unit[i].m_price, i, p_bond_snap->m_bid_unit[i].m_quantity);
    }
    for (int i = 0; i < SZE_LEV2_DEPTH; ++i) {
        printf("m_ask_unit[%d].m_price: %u, m_ask_unit[%d].m_quantity: %llu\n",
               i, p_bond_snap->m_ask_unit[i].m_price, i, p_bond_snap->m_ask_unit[i].m_quantity);
    }
    printf("\n");
}

// 债券逐笔消息
void MyQuoteSpi::on_report_efh_sze_lev2_bond_tick(int msg_type, const sze_hpf_bond_order* p_order, const sze_hpf_bond_exe* p_exe) {
    if (msg_type == SZE_LEV2_BOND_ORDER_MSG_TYPE && p_order) {
        printf("sze_hpf_bond_order:\n");
        printf("m_head.m_sequence: %u\n", p_order->m_head.m_sequence);
        printf("m_head.m_reserved_1: %u\n", p_order->m_head.m_reserved_1);
        printf("m_head.m_message_type: %u\n", p_order->m_head.m_message_type);
        printf("m_head.m_security_type: %u\n", p_order->m_head.m_security_type);
        printf("m_head.m_sub_security_type: %u\n", p_order->m_head.m_sub_security_type);
        printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_order->m_head.m_symbol);
        printf("m_head.m_exchange_id: %u\n", p_order->m_head.m_exchange_id);
        printf("m_head.m_quote_update_time: %llu\n", p_order->m_head.m_quote_update_time);
        printf("m_head.m_channel_num: %u\n", p_order->m_head.m_channel_num);
        printf("m_head.m_sequence_num: %llu\n", p_order->m_head.m_sequence_num);
        printf("m_head.m_md_stream_id: %u\n", p_order->m_head.m_md_stream_id);

        printf("m_price: %u\n", p_order->m_price);
        printf("m_quantity: %llu\n", p_order->m_quantity);
        printf("m_side: %c\n", p_order->m_side);
        printf("m_order_type: %c\n", p_order->m_order_type);
        printf("m_reserved: ");
        for (int i = 0; i < 15; ++i) {
            printf("%02x ", (unsigned char)p_order->m_reserved[i]);
        }
        printf("\n");
    } else if (msg_type == SZE_LEV2_BOND_EXE_MSG_TYPE && p_exe) {
        printf("sze_hpf_bond_exe:\n");
        printf("m_head.m_sequence: %u\n", p_exe->m_head.m_sequence);
        printf("m_head.m_reserved_1: %u\n", p_exe->m_head.m_reserved_1);
        printf("m_head.m_message_type: %u\n", p_exe->m_head.m_message_type);
        printf("m_head.m_security_type: %u\n", p_exe->m_head.m_security_type);
        printf("m_head.m_sub_security_type: %u\n", p_exe->m_head.m_sub_security_type);
        printf("m_head.m_symbol: %.*s\n", SZE_SYMBOL_LEN, p_exe->m_head.m_symbol);
        printf("m_head.m_exchange_id: %u\n", p_exe->m_head.m_exchange_id);
        printf("m_head.m_quote_update_time: %llu\n", p_exe->m_head.m_quote_update_time);
        printf("m_head.m_channel_num: %u\n", p_exe->m_head.m_channel_num);
        printf("m_head.m_sequence_num: %llu\n", p_exe->m_head.m_sequence_num);
        printf("m_head.m_md_stream_id: %u\n", p_exe->m_head.m_md_stream_id);

        printf("m_buy_num: %lld\n", p_exe->m_buy_num);
        printf("m_sell_num: %lld\n", p_exe->m_sell_num);
        printf("m_price: %u\n", p_exe->m_price);
        printf("m_quantity: %lld\n", p_exe->m_quantity);
        printf("m_type: %c\n", p_exe->m_type);
    }
    printf("\n");
}

